package org.msh.tb.export_rest.cases;

import org.codehaus.jackson.annotate.JsonIgnore;
import org.msh.tb.entities.enums.CaseClassification;
import org.msh.utils.date.DateUtils;

import java.util.Date;

/**
 * Information to generate an Excel file with cases to be exported
 * Created by rmemoria on 13/7/17.
 */
public class CaseExportRequest {

    public enum DateToFilter {
        TREATMENT("iniTreatmentDate"),
        DIAGNOSIS("diagnosisDate"),
        REGISTRATION("registrationDate");

        private String field;

        DateToFilter(String field) {
            this.field = field;
        }

        public String getField() {
            return field;
        }
    }

    private Integer iniMonth;
    private Integer iniYear;

    private Integer endMonth;
    private Integer endYear;

    private Integer adminUnitId;
    private Integer unitId;

    private DateToFilter dateToFilter;

    private CaseClassification classification;

    private boolean examsHIV;
    private boolean examsMicroscopy;
    private boolean examsXpert;
    private boolean examsCulture;
    private boolean examsDST;
    private boolean medicalExaminations;
    private boolean examsXray;
    private boolean sideEffect;
    private boolean comorbidities;

    /**
     * Calculate the initial date based on the initial month and year
     *
     * @return the initial date, or null if the year is null
     */
    @JsonIgnore
    public Date getIniDate() {
        if (iniYear == null) {
            return null;
        }
        int month = iniMonth != null ? iniMonth - 1 : 0;

        return DateUtils.newDate(iniYear, month, 1);
    }

    /**
     * Calculate the end date based on the end month and year
     *
     * @return the final date, or null if the end year is null
     */
    @JsonIgnore
    public Date getEndDate() {
        if (endYear == null) {
            return null;
        }

        int month = endMonth != null ? endMonth - 1 : 11;

        return DateUtils.newDate(endYear, month, DateUtils.daysInAMonth(endYear, month));
    }

    public Integer getIniMonth() {
        return iniMonth;
    }

    public void setIniMonth(Integer iniMonth) {
        this.iniMonth = iniMonth;
    }

    public Integer getIniYear() {
        return iniYear;
    }

    public void setIniYear(Integer iniYear) {
        this.iniYear = iniYear;
    }

    public Integer getEndMonth() {
        return endMonth;
    }

    public void setEndMonth(Integer endMonth) {
        this.endMonth = endMonth;
    }

    public Integer getEndYear() {
        return endYear;
    }

    public void setEndYear(Integer endYear) {
        this.endYear = endYear;
    }

    public boolean isExamsHIV() {
        return examsHIV;
    }

    public void setExamsHIV(boolean examsHIV) {
        this.examsHIV = examsHIV;
    }

    public boolean isExamsMicroscopy() {
        return examsMicroscopy;
    }

    public void setExamsMicroscopy(boolean examsMicroscopy) {
        this.examsMicroscopy = examsMicroscopy;
    }

    public boolean isExamsXpert() {
        return examsXpert;
    }

    public void setExamsXpert(boolean examsXpert) {
        this.examsXpert = examsXpert;
    }

    public boolean isExamsCulture() {
        return examsCulture;
    }

    public void setExamsCulture(boolean examsCulture) {
        this.examsCulture = examsCulture;
    }

    public boolean isExamsDST() {
        return examsDST;
    }

    public void setExamsDST(boolean examsDST) {
        this.examsDST = examsDST;
    }

    public boolean isMedicalExaminations() {
        return medicalExaminations;
    }

    public void setMedicalExaminations(boolean medicalExaminations) {
        this.medicalExaminations = medicalExaminations;
    }

    public boolean isExamsXray() {
        return examsXray;
    }

    public void setExamsXray(boolean examsXray) {
        this.examsXray = examsXray;
    }

    public boolean isSideEffect() {
        return sideEffect;
    }

    public void setSideEffect(boolean sideEffect) {
        this.sideEffect = sideEffect;
    }

    public Integer getAdminUnitId() {
        return adminUnitId;
    }

    public void setAdminUnitId(Integer adminUnitId) {
        this.adminUnitId = adminUnitId;
    }

    public Integer getUnitId() {
        return unitId;
    }

    public void setUnitId(Integer unitId) {
        this.unitId = unitId;
    }

    public boolean isComorbidities() {
        return comorbidities;
    }

    public void setComorbidities(boolean comorbidities) {
        this.comorbidities = comorbidities;
    }

    public CaseClassification getClassification() {
        return classification;
    }

    public void setClassification(CaseClassification classification) {
        this.classification = classification;
    }

    public DateToFilter getDateToFilter() {
        return dateToFilter;
    }

    public void setDateToFilter(DateToFilter dateToFilter) {
        this.dateToFilter = dateToFilter;
    }
}
